/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.event;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class ChopEvent
extends Event {
    private final World world;
    private final PlayerEntity player;
    private final BlockPos choppedBlockPos;
    private final BlockState choppedBlockState;

    public ChopEvent(World world, PlayerEntity player, BlockPos choppedBlockPos, BlockState choppedBlockState) {
        this.world = world;
        this.player = player;
        this.choppedBlockPos = choppedBlockPos;
        this.choppedBlockState = choppedBlockState;
    }

    public World getWorld() {
        return this.world;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public BlockPos getChoppedBlockPos() {
        return this.choppedBlockPos;
    }

    public BlockState getChoppedBlockState() {
        return this.choppedBlockState;
    }

    public static class FinishChopEvent
    extends ChopEvent {
        public FinishChopEvent(World world, PlayerEntity player, BlockPos choppedBlockPos, BlockState choppedBlockState) {
            super(world, player, choppedBlockPos, choppedBlockState);
        }
    }

    @Cancelable
    public static class StartChopEvent
    extends ChopEvent {
        private BlockEvent.BreakEvent breakEvent;
        private int numChops;
        private boolean felling;

        public StartChopEvent(BlockEvent.BreakEvent breakEvent, World world, PlayerEntity player, BlockPos choppedBlockPos, BlockState choppedBlockState, int numChops, boolean felling) {
            super(world, player, choppedBlockPos, choppedBlockState);
            this.breakEvent = breakEvent;
            this.numChops = numChops;
            this.felling = felling;
        }

        public BlockEvent.BreakEvent getBreakEvent() {
            return this.breakEvent;
        }

        public int getNumChops() {
            return this.numChops;
        }

        public boolean getFelling() {
            return this.felling;
        }

        public void setNumChops(int numChops) {
            this.numChops = numChops;
        }

        public void setFelling(boolean felling) {
            this.felling = felling;
        }
    }

    @Cancelable
    public static class DetectTreeEvent
    extends ChopEvent {
        private final AtomicBoolean hasLeaves;
        private final AtomicBoolean overrideHasLeaves;

        public DetectTreeEvent(World world, PlayerEntity player, BlockPos choppedBlockPos, BlockState choppedBlockState, AtomicBoolean hasLeaves, AtomicBoolean overrideHasLeaves) {
            super(world, player, choppedBlockPos, choppedBlockState);
            this.overrideHasLeaves = overrideHasLeaves;
            this.hasLeaves = hasLeaves;
        }

        public void overrideTreeHasLeaves(boolean hasLeaves) {
            this.hasLeaves.set(hasLeaves);
            this.overrideHasLeaves.set(true);
        }
    }
}

